/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class CreerObjet {
    private static Logger log = Logger.getLogger(CreerObjet.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, String string, String string2) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                ResultatInfo resultatInfo = null;
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                resultatInfo = new ResultatInfo("Cr\u00e9ation de l'objet \"" + string + "\" (C_CreateObject)");
                resultatInfo.setInfos(linkedHashMap);
                if (string != null && string2 != null) {
                    CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[5];
                    for (int i = 0; i < 5; ++i) {
                        cK_ATTRIBUTEArray[i] = new CK_ATTRIBUTE();
                    }
                    cK_ATTRIBUTEArray[0].type = 0L;
                    cK_ATTRIBUTEArray[0].pValue = 0L;
                    cK_ATTRIBUTEArray[1].type = 1L;
                    cK_ATTRIBUTEArray[1].pValue = true;
                    cK_ATTRIBUTEArray[2].type = 16L;
                    cK_ATTRIBUTEArray[2].pValue = "ProgrammeExemple";
                    cK_ATTRIBUTEArray[3].type = 3L;
                    cK_ATTRIBUTEArray[3].pValue = string.toCharArray();
                    cK_ATTRIBUTEArray[4].type = 17L;
                    cK_ATTRIBUTEArray[4].pValue = TraitementsUtil.getOctetsSansFormatage(string2);
                    try {
                        long l2 = pKCS11.C_CreateObject(l, cK_ATTRIBUTEArray);
                        linkedHashMap.put("Identifiant de l'objet", Long.toString(l2));
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                        resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                    }
                    return resultatInfo;
                }
                log.error((Object)"Le libelle et/ou les donn\u00e9es sont nuls");
                throw new ExceptionTraitement(19, "Le libelle et/les donn\u00e9es sont nuls");
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(19, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(19, "Une erreur inattendue est survenue");
        }
    }
}

